/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.components;

import dev.lucaargolo.charta.client.gui.components.AbstractCardWidget;
import dev.lucaargolo.charta.client.gui.screens.GameScreen;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardSlotWidget<G extends CardGame<G>>
extends AbstractCardWidget {
    private final GameScreen<G, ?> parent;
    private final CardSlot<G> cardSlot;
    private final List<CardSlotWidget<G>> renderables = new ArrayList<CardSlotWidget<G>>();
    private boolean renderablesDirty = false;
    private CardSlotWidget<G> hoverable = null;

    public CardSlotWidget(GameScreen<G, ?> parent, CardSlot<G> slot) {
        super(parent, null, null, 0xFFFFFF, slot.x, slot.y, slot.isSmall() ? 0.333f : 1.0f);
        this.parent = parent;
        this.cardSlot = slot;
    }

    @Override
    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        GameSlot slot = this.cardSlot.getSlot();
        if (this.cardSlot.isExtended()) {
            this.setPreciseWidth(CardSlot.getWidth(this.cardSlot));
            this.setPreciseHeight(CardSlot.getHeight(this.cardSlot));
            if (this.renderables.size() != slot.size() || this.renderablesDirty) {
                this.hoverable = null;
                this.renderables.clear();
                float left = 0.0f;
                float leftOffset = 0.0f;
                float topOffset = 0.0f;
                float childWidth = this.cardSlot.isSmall() ? CardSlot.getWidth(CardSlot.Type.SMALL) : CardSlot.getWidth(CardSlot.Type.DEFAULT);
                float maxLeftOffset = childWidth + childWidth / 10.0f;
                if (this.cardSlot.getType() != CardSlot.Type.VERTICAL) {
                    leftOffset = childWidth + Math.max(0.0f, this.getPreciseWidth() - (float)slot.size() * childWidth / (float)slot.size());
                    float totalWidth = childWidth + leftOffset * ((float)slot.size() - 1.0f);
                    float leftExcess = totalWidth - this.getPreciseWidth();
                    if (leftExcess > 0.0f) {
                        leftOffset -= leftExcess / ((float)slot.size() - 1.0f);
                    }
                    totalWidth = childWidth + maxLeftOffset * ((float)slot.size() - 1.0f);
                    left = 0.0f;
                    if (leftOffset > maxLeftOffset) {
                        left = Math.max(leftOffset - maxLeftOffset, this.getPreciseWidth() - totalWidth);
                        leftOffset = maxLeftOffset;
                    }
                } else {
                    topOffset = 10.0f;
                    if (topOffset * (float)(slot.size() - 1) + CardSlot.getHeight(CardSlot.Type.DEFAULT) > this.getPreciseHeight()) {
                        topOffset = (this.getPreciseHeight() - CardSlot.getHeight(CardSlot.Type.DEFAULT)) / (float)(slot.size() - 1);
                    }
                }
                int i = 0;
                for (Card card : slot.getCards()) {
                    int index = i;
                    CardSlot<CardGame> childCardSlot = new CardSlot<CardGame>((CardGame)((AbstractCardMenu)this.parent.method_17577()).getGame(), g -> new GameSlot(List.of(card)), this.cardSlot.x + leftOffset * (float)i, this.cardSlot.y + topOffset * (float)i, this.cardSlot.isSmall() ? CardSlot.Type.SMALL : CardSlot.Type.DEFAULT);
                    ChildCardSlotWidget child = new ChildCardSlotWidget(this.parent, childCardSlot, index, class_3532.method_15375((float)leftOffset), class_3532.method_15375((float)topOffset));
                    child.setPreciseX(childCardSlot.x + (float)this.parent.field_2776 + left / 2.0f);
                    if (this.cardSlot.getType() == CardSlot.Type.HORIZONTAL) {
                        child.setPreciseY(childCardSlot.y + (float)this.parent.field_22790 - child.getPreciseHeight());
                    } else if (this.cardSlot.getType() == CardSlot.Type.PREVIEW) {
                        child.setPreciseY(childCardSlot.y);
                    } else {
                        child.setPreciseY(childCardSlot.y + (float)this.parent.field_2800);
                    }
                    this.renderables.add(child);
                    ++i;
                }
                this.renderablesDirty = false;
            }
            for (CardSlotWidget<G> renderable : this.renderables) {
                if (renderable == this.hoverable && this.cardSlot.getType() != CardSlot.Type.VERTICAL) continue;
                if (this.hoverable != null && this.cardSlot.getType() != CardSlot.Type.VERTICAL) {
                    this.hoverable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                }
                renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                if (!renderable.field_22762 || this.cardSlot.getType() != CardSlot.Type.VERTICAL && this.hoverable != null && this.hoverable.field_22762) continue;
                this.hoverable = renderable;
            }
            if (this.hoverable != null) {
                if (this.cardSlot.getType() != CardSlot.Type.VERTICAL) {
                    this.hoverable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                }
                if (!this.hoverable.field_22762) {
                    this.hoverable = null;
                }
            }
        } else {
            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void tick(int mouseX, int mouseY) {
        super.tick(mouseX, mouseY);
        int i = 0;
        for (CardSlotWidget<G> renderable : this.renderables) {
            GameSlot slot = this.cardSlot.getSlot();
            if (i >= slot.size() || !renderable.cardSlot.getSlot().contains(slot.get(i))) {
                this.renderablesDirty = true;
            }
            if (this.cardSlot.getType() != CardSlot.Type.VERTICAL || i == this.renderables.size() - 1) {
                renderable.tick(mouseX, mouseY);
            } else {
                renderable.tick(mouseX, mouseY + 20);
            }
            ++i;
        }
    }

    @Override
    @NotNull
    public class_2960 getCardTexture(@Nullable class_2960 cardId, boolean glow) {
        Card card = this.cardSlot.getSlot().getLast();
        if (card.isFlipped()) {
            return this.parent.getDeck().getDeckTexture(glow);
        }
        return this.parent.getDeck().getCardTexture(card, glow);
    }

    @Override
    public String getCardTranslatableKey() {
        Card card = this.cardSlot.getSlot().getLast();
        return this.parent.getDeck().getCardTranslatableKey(card);
    }

    @Override
    public int getCardColor() {
        Card card = this.cardSlot.getSlot().getLast();
        return this.parent.getDeck().getCardColor(card);
    }

    @Override
    public boolean method_49606() {
        return this.parent.isHoveredCardSlot(this.cardSlot);
    }

    public int getHoveredId() {
        return this.hoverable != null ? this.hoverable.getHoveredId() : -1;
    }

    private class ChildCardSlotWidget
    extends CardSlotWidget<G> {
        private final int index;
        private final float leftOffset;
        private final float topOffset;

        public ChildCardSlotWidget(GameScreen<G, ?> parent, CardSlot<G> slot, int index, float leftOffset, float topOffset) {
            super(parent, slot);
            this.index = index;
            this.leftOffset = leftOffset;
            this.topOffset = topOffset;
        }

        public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (this.field_22764) {
                float actualWidth = this.getPreciseWidth();
                if (CardSlotWidget.this.cardSlot.getType() != CardSlot.Type.VERTICAL && !this.method_49606() && this.index < CardSlotWidget.this.cardSlot.getSlot().size() - 1) {
                    actualWidth = this.leftOffset;
                }
                float actualHeight = this.getPreciseHeight();
                if (CardSlotWidget.this.cardSlot.getType() == CardSlot.Type.VERTICAL && !this.method_49606() && this.index < CardSlotWidget.this.cardSlot.getSlot().size() - 1) {
                    actualHeight = this.topOffset;
                }
                this.field_22762 = guiGraphics.method_58135(mouseX, mouseY) && mouseX >= this.method_46426() && mouseY >= this.method_46427() && (float)mouseX < (float)this.method_46426() + actualWidth && (float)mouseY < (float)this.method_46427() + actualHeight;
            }
        }

        @Override
        public int getHoveredId() {
            return this.index;
        }

        @Override
        public boolean method_49606() {
            return CardSlotWidget.this.hoverable == this;
        }
    }
}

